;------------------------------------------------------------------------
; Ultra64
; U64Emu Platinum Edition v3.11
; by djvj
; 1.0
;
; Notes:
; This emulator only plays Killer Instinct 1 and Killer Instinct 2
; Settings are stored in your registry at HKEY_CURRENT_USER\Software\U64Emu\u64emu
; Roms should be unzipped and match the dirs set in the emuator Rom Settings.
; Mame CHDs don't work, you need the IMG versions, or use the patcher tool to convert your CHD to IMG
; Controls can be remapped near the bottom of the script. Can't move it up or else the emu fails to launch.
;
; To use this in your MAME wheel:
; Add the <exe>u64emu</exe> tag to both "kinst" and "kinst2" entries in your database
; Create a u64emu folder in your Modules folder and place this script in there. The name of this script must match the exe tag in your database
; Create a u64emu.ini in your Hyperspin\Settings folder. Open your MAME.ini in this folder and copy the [exe info] section into the u64emu.ini and change the "path" and "exe" to this emulator
;------------------------------------------------------------------------

Fullscreen = true
Resolution = 3 ; 0=320x240, 1=640x480, 2=800x600, 3=1024x768, 4=1280x1024, 5=1600x1200
LoadingScreen = true
WinX = 0 ; For windowed mode only
WinY = 0

; This gets rid of the emu window that pops up on launch
If ( LoadingScreen = "true" ) {
		Gui +AlwaysOnTop -Caption +ToolWindow
		Gui Color, Black
		Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
	}

; Set Resolution
If ( Resolution = 0 )
	WriteReg("ScreenRes", 0)
Else If ( Resolution = 1 )
	WriteReg("ScreenRes", 1)
Else If ( Resolution = 2 )
	WriteReg("ScreenRes", 2)
Else If ( Resolution = 3 )
	WriteReg("ScreenRes", 3)
Else If ( Resolution = 4 )
	WriteReg("ScreenRes", 4)
Else If ( Resolution = 5 )
	WriteReg("ScreenRes", 5)

; Set Fullscreen
If ( Fullscreen = "true" )
	WriteReg("FullScreen", 1)
Else
	WriteReg("FullScreen", 0)

; Setting the game we want to play
If ( romName = "kinst" )
	WriteReg("RomSet", 1)
Else If ( romName = "kinst2" )
	WriteReg("RomSet", 2)

Run, %executable%, %emuPath%
WinWait, U64Emu Platinum Edition
Send, {ALT}{e}{s}
Sleep, 1000

; In windowed mode, the game screen is never fully on screen and the emu doesn't save its last position. It doesn't take effect if you run fullscreen.
If ( Fullscreen != "true" && romName = "kinst" )
	WinMove, AHK_class #32770, , %WinX%, %WinY%
Else If ( Fullscreen != "true" && romName = "kinst2" )
	WinMove, AHK_class #32770, , %WinX%, %WinY%

Gui Destroy

;(`._.`._.`._.`._.`._.`._.`._.)
; Remap your controls here (defaults are already provided), just place your key to the left of the :: and uncomment the line
; Example  to_key::from_key

; Game Controls
; ::F11		; Service Menu
; ::-			; Volume Up
; ::+			; Volume Down

; Player 1 Controls
; ::Home	; Up
; ::End		; Down
; ::Delete	; Left
; ::PgDn	; Right
; ::w			; Quick Punch
; ::e			; Medium Punch
; ::r			; Fierce Punch
; ::s			; Quick Kick
; ::d			; Medium Kick
; ::f			; Fierce Kick
; ::q			; Start
; ::F7		; Coin

; Player 2 Controls
; ::Up		; Up
; ::Down	; Down
; ::Left		; Left
; ::Right	; Right
; ::u			; Quick Punch
; ::i			; Medium Punch
; ::p			; Fierce Punch
; ::j			; Quick Kick
; ::k			; Medium Kick
; ::l			; Fierce Kick
; ::y			; Start
; ::F8		; Coin
;(_.`._.`._.`._.`._.`._.`._.`._)

Process, WaitClose, %executable%

ExitApp

WriteReg(var1, var2) {
	RegWrite, REG_DWORD, HKEY_CURRENT_USER, Software\U64Emu\u64emu\Options, %var1%, %var2%
	RegWrite, REG_DWORD, HKEY_CURRENT_USER, Software\U64Emu\u64emu\KI2_Options, %var1%, %var2%
}

CloseProcess:
return